/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.PlanImageRGB;
import cds.aladin.ResourceNode;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class PlanImageColor
extends PlanImageRGB {
    protected PlanImageColor(Aladin aladin, String file, URL u, MyInputStream inImg) {
        super(aladin, file, u, inImg);
    }

    protected PlanImageColor(Aladin aladin, String file, URL u, MyInputStream inImg, ResourceNode imgNode) {
        super(aladin, file, u, inImg, imgNode);
    }

    protected PlanImageColor(Aladin aladin, MyInputStream inImg, int orig, URL u, String label, String objet, String param, String from, int fmt, int res, Obj o, ResourceNode imgNode) {
        super(aladin, inImg, orig, u, label, objet, param, from, fmt, res, o, imgNode);
        this.flagBlue = true;
        this.flagGreen = true;
        this.flagRed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean cacheImageNatif(MyInputStream dis) {
        Date d = new Date();
        this.setPourcent(1.0);
        Aladin.trace(2, "Loading colored image");
        long t = System.currentTimeMillis();
        ImageInputStream iis = null;
        try {
            long type = dis.getType();
            String fmt = (type & 2L) != 0L ? "jpeg" : ((type & 0x10000L) != 0L ? "png" : "gif");
            this.setPixMode((type & 2L) != 0L ? 1 : 0);
            Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(fmt);
            ImageReader reader = readers.next();
            iis = ImageIO.createImageInputStream(dis);
            reader.setInput(iis, true);
            this.naxis1 = this.width = reader.getWidth(0);
            this.naxis2 = this.height = reader.getHeight(0);
            long t1 = System.currentTimeMillis();
            Aladin.trace(3, "image (" + fmt + ") " + this.width + "x" + this.height + " created&loaded in " + (t1 - t) + " ms");
            t = t1;
            ImageReadParam param = reader.getDefaultReadParam();
            double mem = this.aladin.getMem();
            double taille = (double)(this.width * this.height) * 4.0 / 1048576.0;
            Aladin.trace(4, "PlanImageColor.cacheImageNatif()... RAM=" + mem + "MB imageSize=" + taille + "MB");
            if (mem < taille) {
                throw new Exception("Not enough memory for this image => required " + taille + "MB !");
            }
            Aladin.trace(4, "PlanImageColor.cacheImageNatif()... loading huge image piece by piece...");
            BufferedImage buf = new BufferedImage(this.width, this.height, 2);
            Graphics g = buf.getGraphics();
            int size = 1024;
            double incrPourcent = 98.0 / ((double)this.width * (double)this.height / (double)(size * size));
            double pourcent = 0.0;
            for (int y = 0; y < this.height; y += size) {
                for (int x = 0; x < this.width; x += size) {
                    this.setPourcent(pourcent += incrPourcent);
                    int w = x + size > this.width ? this.width - x : size;
                    int h = y + size > this.height ? this.height - y : size;
                    Rectangle r = new Rectangle(x, y, w, h);
                    param.setSourceRegion(r);
                    BufferedImage itmp = reader.read(0, param);
                    g.drawImage(itmp, x, y, this.aladin);
                }
            }
            g.finalize();
            g = null;
            this.pixelsRGB = ((DataBufferInt)buf.getRaster().getDataBuffer()).getData();
            buf.flush();
            buf = null;
            t1 = System.currentTimeMillis();
            Aladin.trace(3, "RGB pixels extracted in " + (t1 - t) + " ms");
            t = t1;
            Date d1 = new Date();
            int temps = (int)(d1.getTime() - d.getTime());
            d = d1;
            Aladin.trace(3, " => Loading in " + temps + " ms");
            this.cm = ColorModel.getRGBdefault();
            this.setPourcent(99.0);
            this.video = 0;
        }
        catch (Exception e) {
            this.setPourcent(-1.0);
            Aladin.error = e.getMessage();
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (iis != null) {
                try {
                    iis.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }
}

